#include <SHT21.h>  // Include SHT21 library

SHT21 sht; 

float temp;       // Variable to store temperature
float humidity;   // Variable to store humidity

const int ledPin = 2;  // Pin connected to the LED

void setup() {
  Wire.begin();       // Begin Wire(I2C)
  Serial.begin(9600); // Begin Serial communication
  pinMode(ledPin, OUTPUT);  // Set the LED pin as output
}

void loop() {
  // Get temperature and humidity from the sensor
  temp = sht.getTemperature();
  humidity = sht.getHumidity();

  // Print readings to the serial monitor
  Serial.print("Temp: ");
  Serial.print(temp);
  Serial.print("\t Humidity: ");
  Serial.println(humidity);

  // Control the LED based on temperature thresholds
  if (temp > 30) {
    digitalWrite(ledPin, HIGH);  // Turn the LED on
    Serial.print("The temperature is high!");
  } else if (temp <= 25) {
    digitalWrite(ledPin, LOW);   // Turn the LED off
    Serial.print("it's cool!");
  }

  delay(5000);  // Wait for 1 second before the next measurement
}
